// Face Tracking.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

// usage: facedetect --cascade=<path> image_name
#include "cv.h"
#include "highgui.h"
#include <string.h>

int main( int argc, char** argv )
{
   CvHaarClassifierCascade* cascade;
   
   // face sequence will reside in the storage
   CvMemStorage* storage=cvCreateMemStorage(0);
   IplImage *image;
   CvSeq* faces;
   int optlen = strlen("--cascade=");
   int i;

   if( argc != 3 ||
       strncmp(argv[1], "--cascade=", optlen) )
       return -1;
   
   // load classifier cascade from XML file
   cascade = (CvHaarClassifierCascade*)
       cvLoad( argv[1] + optlen );
   // load image from the specified file
   image = cvLoadImage( argv[2], 1 );

   if( !cascade || !image )
       return -1;

   
   // get the sequence of face rectangles
   faces = cvHaarDetectObjects( image,
     cascade, storage,
     1.2, // scale the cascade
          // by 20% after each pass
     2, // groups of 3 (2+1) or more neighbor face rectangles are joined into a single "face", smaller groups are rejected
     CV_HAAR_DO_CANNY_PRUNING, // use Canny edge detector to reduce number of false alarms
     cvSize(0, 0) // start from the minimum face size allowed by the particular classifier
    );
    
   // for each face draw the bounding rectangle
   for(i=0;i<(faces ? faces->total:0); i++ ) {
      CvRect* r = (CvRect*)
           cvGetSeqElem( faces, i );
      CvPoint pt1 = { r->x, r->y };
      CvPoint pt2 = { r->x + r->width,
                      r->y + r->height };
      cvRectangle( image, pt1, pt2,
                   CV_RGB(255,0,0), 3, 8, 0 );
   }
    
   // create window and show the image with outlined faces
   cvNamedWindow( "faces", 1 );
   cvShowImage( "faces", image );
   char* filename = "JacekFace.jpg";
   cvSaveImage(filename, image);
   cvWaitKey();

   // after a key pressed, release data
   cvReleaseImage( &image );
   cvReleaseHaarClassifierCascade( &cascade );
   cvReleaseMemStorage( &storage );
   return 0;
}


